﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    public struct VertexPositionNormalTextureTangentBinormal : IVertexType
    {
        public Vector3 Position;
        public Vector3 Normal;
        public Vector2 TextureCoordinate;
        public Vector3 Tangent;
        public Vector3 Binormal;

        private readonly static VertexElement[] VertexElements =
        {
            new VertexElement(0,VertexElementFormat.Vector3,VertexElementUsage.Position,0),
            new VertexElement(3*sizeof(float),VertexElementFormat.Vector3,VertexElementUsage.Normal,0),
            new VertexElement(6*sizeof(float),VertexElementFormat.Vector2,VertexElementUsage.TextureCoordinate,0),
            new VertexElement(8*sizeof(float),VertexElementFormat.Vector3,VertexElementUsage.TextureCoordinate,3), //VertexElementUsage.Tangent
            new VertexElement(11*sizeof(float),VertexElementFormat.Vector3,VertexElementUsage.TextureCoordinate,4) //VertexElementUsage.Binormal
        };

        public readonly static VertexDeclaration VertexDeclaration = new VertexDeclaration(VertexElements);

        VertexDeclaration IVertexType.VertexDeclaration
        {
            get
            {
                return VertexDeclaration;
            }
        }

        public VertexPositionNormalTextureTangentBinormal(Vector3 position, Vector3 normal, Vector2 textureCoordinate, Vector3 tangent, Vector3 binormal)
        {
            this.Position = position;
            this.Normal = normal;
            this.TextureCoordinate = textureCoordinate;
            this.Tangent = tangent;
            this.Binormal = binormal;
        }
    }
}
